using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgPatientAntigenTypingSpecificity
	/// </summary>
	public class DlgPatientAntigenTypingSpecificity : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpAntisera;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.Label lblAntisera;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.GroupBox grpTestingPhases;
		private System.Windows.Forms.RadioButton rdoIS;
		private System.Windows.Forms.RadioButton rdoISRT;
		private System.Windows.Forms.RadioButton rdoIS37;
		private System.Windows.Forms.RadioButton rdoAHGCC;
		private System.Windows.Forms.TextBox txtAntiserum;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.Button btnCancel;
		private DataTable _dtReagents;
		private BOL.Reagent _reagent;
		private int[] _phase;
		private System.Windows.Forms.GroupBox grpTestingMethod;
		private System.Windows.Forms.RadioButton rdoSolidPhase;
		private System.Windows.Forms.RadioButton rdoGel;
		private System.Windows.Forms.RadioButton rdoTube;
		private DateTime _testingDateTime;
		private Common.TestingMethod _testMethod;
		private BOL.ExceptionReport _exRep;
		private string _testingTech;
		private Guid _patientGuid;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="reagent"></param>
		/// <param name="phase"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="testingTech"></param>
		/// <param name="patientGuid"></param>
		public DlgPatientAntigenTypingSpecificity(ref BOL.Reagent reagent, ref int[] phase, DateTime testingDateTime, string testingTech, Guid patientGuid)
		{
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC098.DlgPatientAntigenTypingSpecificity());
			//
			_reagent = reagent;
			_phase = phase;
			this._testingTech = testingTech;
			_testingDateTime = testingDateTime;
			LoadReagents();

			if (this._phase[0] == (int)Common.ReactivityPhase.ThreeSevenandAHG) //WeakD
			{
				this.grpTestingPhases.Enabled = false;
			}

			_patientGuid = patientGuid;
		}

		/// <summary>
		/// ReactivityPhase
		/// </summary>
		public Common.TestingMethod TestMethod
		{
			get
			{
				return this._testMethod;
			}
		}

		/// <summary>
		/// ExpiredAntiseraException
		/// </summary>
		public BOL.ExceptionReport ExpiredAntiseraException
		{
			get
			{
				return this._exRep;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgPatientAntigenTypingSpecificity));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpAntisera = new System.Windows.Forms.GroupBox();
			this.txtAntiserum = new System.Windows.Forms.TextBox();
			this.cmbLotNumber = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.lblAntisera = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.grpTestingPhases = new System.Windows.Forms.GroupBox();
			this.rdoIS = new System.Windows.Forms.RadioButton();
			this.rdoISRT = new System.Windows.Forms.RadioButton();
			this.rdoIS37 = new System.Windows.Forms.RadioButton();
			this.rdoAHGCC = new System.Windows.Forms.RadioButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpTestingMethod = new System.Windows.Forms.GroupBox();
			this.rdoSolidPhase = new System.Windows.Forms.RadioButton();
			this.rdoGel = new System.Windows.Forms.RadioButton();
			this.rdoTube = new System.Windows.Forms.RadioButton();
			this.grpImage.SuspendLayout();
			this.grpAntisera.SuspendLayout();
			this.grpTestingPhases.SuspendLayout();
			this.grpTestingMethod.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(344, 30);
			this.vbecsLogo1.Title = "Antigen Typing Details";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 273);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(56, 224);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpAntisera
			// 
			this.grpAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntisera.Controls.Add(this.txtAntiserum);
			this.grpAntisera.Controls.Add(this.cmbLotNumber);
			this.grpAntisera.Controls.Add(this.lblLotNumber);
			this.grpAntisera.Controls.Add(this.lblAntisera);
			this.grpAntisera.Controls.Add(this.txtExpirationDate);
			this.grpAntisera.Controls.Add(this.lblExpirationDate);
			this.grpAntisera.Controls.Add(this.txtManufacturer);
			this.grpAntisera.Controls.Add(this.lblManufacturer);
			this.grpAntisera.Location = new System.Drawing.Point(64, 32);
			this.grpAntisera.Name = "grpAntisera";
			this.grpAntisera.Size = new System.Drawing.Size(276, 120);
			this.grpAntisera.TabIndex = 0;
			this.grpAntisera.TabStop = false;
			this.grpAntisera.Text = "Define Antiserum Specificity";
			// 
			// txtAntiserum
			// 
			this.txtAntiserum.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntiserum.Location = new System.Drawing.Point(80, 20);
			this.txtAntiserum.Name = "txtAntiserum";
			this.txtAntiserum.ReadOnly = true;
			this.txtAntiserum.Size = new System.Drawing.Size(172, 20);
			this.txtAntiserum.TabIndex = 0;
			this.txtAntiserum.Text = "";
			// 
			// cmbLotNumber
			// 
			this.cmbLotNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbLotNumber.Interval = 500;
			this.cmbLotNumber.Location = new System.Drawing.Point(80, 44);
			this.cmbLotNumber.Name = "cmbLotNumber";
			this.cmbLotNumber.Size = new System.Drawing.Size(172, 22);
			this.cmbLotNumber.TabIndex = 1;
			this.cmbLotNumber.Validating += new System.ComponentModel.CancelEventHandler(this.cmbLotNumber_Validating);
			this.cmbLotNumber.SelectedIndexChanged += new System.EventHandler(this.cmbLotNumber_SelectedIndexChanged);
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(4, 44);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(88, 20);
			this.lblLotNumber.TabIndex = 2;
			this.lblLotNumber.Text = "Lot Number*";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblAntisera
			// 
			this.lblAntisera.Location = new System.Drawing.Point(4, 20);
			this.lblAntisera.Name = "lblAntisera";
			this.lblAntisera.Size = new System.Drawing.Size(88, 20);
			this.lblAntisera.TabIndex = 0;
			this.lblAntisera.Text = "Antiserum";
			this.lblAntisera.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(80, 92);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(172, 20);
			this.txtExpirationDate.TabIndex = 3;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(4, 92);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(84, 20);
			this.lblExpirationDate.TabIndex = 56;
			this.lblExpirationDate.Text = "Expires";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(80, 68);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(172, 20);
			this.txtManufacturer.TabIndex = 2;
			this.txtManufacturer.Text = "";
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(4, 68);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(88, 20);
			this.lblManufacturer.TabIndex = 54;
			this.lblManufacturer.Text = "Manufacturer";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpTestingPhases
			// 
			this.grpTestingPhases.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingPhases.Controls.Add(this.rdoIS);
			this.grpTestingPhases.Controls.Add(this.rdoISRT);
			this.grpTestingPhases.Controls.Add(this.rdoIS37);
			this.grpTestingPhases.Controls.Add(this.rdoAHGCC);
			this.grpTestingPhases.Location = new System.Drawing.Point(228, 156);
			this.grpTestingPhases.Name = "grpTestingPhases";
			this.grpTestingPhases.Size = new System.Drawing.Size(112, 100);
			this.grpTestingPhases.TabIndex = 4;
			this.grpTestingPhases.TabStop = false;
			this.grpTestingPhases.Text = "Testing Phases*";
			// 
			// rdoIS
			// 
			this.rdoIS.Location = new System.Drawing.Point(8, 16);
			this.rdoIS.Name = "rdoIS";
			this.rdoIS.Size = new System.Drawing.Size(36, 20);
			this.rdoIS.TabIndex = 0;
			this.rdoIS.TabStop = true;
			this.rdoIS.Text = "&IS";
			this.rdoIS.CheckedChanged += new System.EventHandler(this.rdoIS_CheckedChanged);
			// 
			// rdoISRT
			// 
			this.rdoISRT.Location = new System.Drawing.Point(8, 36);
			this.rdoISRT.Name = "rdoISRT";
			this.rdoISRT.Size = new System.Drawing.Size(52, 20);
			this.rdoISRT.TabIndex = 1;
			this.rdoISRT.Text = "IS/&RT";
			this.rdoISRT.CheckedChanged += new System.EventHandler(this.rdoISRT_CheckedChanged);
			// 
			// rdoIS37
			// 
			this.rdoIS37.Location = new System.Drawing.Point(8, 56);
			this.rdoIS37.Name = "rdoIS37";
			this.rdoIS37.Size = new System.Drawing.Size(56, 20);
			this.rdoIS37.TabIndex = 2;
			this.rdoIS37.Text = "IS/&37";
			this.rdoIS37.CheckedChanged += new System.EventHandler(this.rdoIS37_CheckedChanged);
			// 
			// rdoAHGCC
			// 
			this.rdoAHGCC.Location = new System.Drawing.Point(8, 76);
			this.rdoAHGCC.Name = "rdoAHGCC";
			this.rdoAHGCC.Size = new System.Drawing.Size(68, 20);
			this.rdoAHGCC.TabIndex = 3;
			this.rdoAHGCC.Text = "&AHG/CC";
			this.rdoAHGCC.CheckedChanged += new System.EventHandler(this.rdoAHGCC_CheckedChanged);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(264, 259);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(184, 259);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// grpTestingMethod
			// 
			this.grpTestingMethod.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingMethod.Controls.Add(this.rdoSolidPhase);
			this.grpTestingMethod.Controls.Add(this.rdoGel);
			this.grpTestingMethod.Controls.Add(this.rdoTube);
			this.grpTestingMethod.Location = new System.Drawing.Point(64, 156);
			this.grpTestingMethod.Name = "grpTestingMethod";
			this.grpTestingMethod.Size = new System.Drawing.Size(160, 100);
			this.grpTestingMethod.TabIndex = 6;
			this.grpTestingMethod.TabStop = false;
			this.grpTestingMethod.Text = "Testing Method*";
			// 
			// rdoSolidPhase
			// 
			this.rdoSolidPhase.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoSolidPhase.Location = new System.Drawing.Point(16, 56);
			this.rdoSolidPhase.Name = "rdoSolidPhase";
			this.rdoSolidPhase.Size = new System.Drawing.Size(131, 20);
			this.rdoSolidPhase.TabIndex = 2;
			this.rdoSolidPhase.Text = "Solid &Phase";
			this.rdoSolidPhase.CheckedChanged += new System.EventHandler(this.rdoSolidPhase_CheckedChanged);
			// 
			// rdoGel
			// 
			this.rdoGel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoGel.Location = new System.Drawing.Point(16, 36);
			this.rdoGel.Name = "rdoGel";
			this.rdoGel.Size = new System.Drawing.Size(131, 20);
			this.rdoGel.TabIndex = 1;
			this.rdoGel.Text = "&Gel";
			this.rdoGel.CheckedChanged += new System.EventHandler(this.rdoGel_CheckedChanged);
			// 
			// rdoTube
			// 
			this.rdoTube.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoTube.Checked = true;
			this.rdoTube.Location = new System.Drawing.Point(16, 16);
			this.rdoTube.Name = "rdoTube";
			this.rdoTube.Size = new System.Drawing.Size(131, 20);
			this.rdoTube.TabIndex = 0;
			this.rdoTube.TabStop = true;
			this.rdoTube.Text = "&Tube";
			this.rdoTube.CheckedChanged += new System.EventHandler(this.rdoTube_CheckedChanged);
			// 
			// DlgPatientAntigenTypingSpecificity
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(344, 289);
			this.Controls.Add(this.grpTestingMethod);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpAntisera);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpTestingPhases);
			this.hlphelpChm.SetHelpKeyword(this, "Record_a_Patient_Antigen_Typing.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(350, 316);
			this.Name = "DlgPatientAntigenTypingSpecificity";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Antigen Typing Details";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.DlgPatientAntigenTypingSpecificity_Closing);
			this.Controls.SetChildIndex(this.grpTestingPhases, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpAntisera, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpTestingMethod, 0);
			this.grpImage.ResumeLayout(false);
			this.grpAntisera.ResumeLayout(false);
			this.grpTestingPhases.ResumeLayout(false);
			this.grpTestingMethod.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void LoadReagents()
		{
			this.txtAntiserum.Text = this._reagent.ReagentType.ReagentTypeName;

			this._dtReagents = BOL.Reagent.GetReagentsByType(LogonUser.LogonUserDivisionCode, this._reagent.ReagentType.ReagentTypeId);

			foreach(DataRow drReagent in this._dtReagents.Rows)
			{
				this.cmbLotNumber.Items.Add(drReagent[Common.VbecsTables.Reagent.LotNumber].ToString());
			}
		}

		private void cmbLotNumber_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbLotNumber.SelectedIndex != -1)
			{
				if (this.CheckForExpiredAntisera(this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex]) == true &&
					this.CheckForSatisfactoryReagent(this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex]) == true)
				{
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.LotExpirationDate]);
					this.txtManufacturer.Text = this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();

					if (this.rdoAHGCC.Checked ||
						this.rdoIS.Checked ||
						this.rdoIS37.Checked ||
						this.rdoISRT.Checked ||
						this.grpTestingPhases.Enabled == false)
					{
						if (this.rdoTube.Checked ||
							this.rdoGel.Checked ||
							this.rdoSolidPhase.Checked)
						{
							this.btnOK.EnabledButton = true;
							this.btnOK.SetToolTip("");
						}
						else
						{
							this.btnOK.EnabledButton = false;
							this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC021.TestingMethod().ResString);
						}
					}
					else
					{
						this.btnOK.EnabledButton = false;
						this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChoosePhase().ResString);
					}
				}
				else
				{
					this.cmbLotNumber.Text = "";
					this.cmbLotNumber.SelectedIndex = -1;
					this.btnOK.EnabledButton = false;
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChooseLotNumber().ResString);
				}
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChooseLotNumber().ResString);
			}
		}

		private void rdoIS_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoIS.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoTube.Checked ||
				 this.rdoGel.Checked ||
				 this.rdoSolidPhase.Checked))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void rdoISRT_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoISRT.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoTube.Checked ||
				this.rdoGel.Checked ||
				this.rdoSolidPhase.Checked))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void rdoIS37_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoIS37.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoTube.Checked ||
				this.rdoGel.Checked ||
				this.rdoSolidPhase.Checked))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void rdoAHGCC_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoAHGCC.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoTube.Checked ||
				this.rdoGel.Checked ||
				this.rdoSolidPhase.Checked))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void cmbLotNumber_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (this.cmbLotNumber.SelectedIndex == -1)
			{
				this.txtAntiserum.Text = "";
				this.txtExpirationDate.Text = "";
				this.txtManufacturer.Text = "";
				this.btnOK.EnabledButton = false;
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC056.ChooseLotNumber().ResString);
			}
		}

		private void rdoTube_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoTube.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoIS.Checked ||
				this.rdoIS37.Checked ||
				this.rdoISRT.Checked ||
				this.rdoAHGCC.Checked ||
				this.grpTestingPhases.Enabled == false))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void rdoGel_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoGel.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoIS.Checked ||
				this.rdoIS37.Checked ||
				this.rdoISRT.Checked ||
				this.rdoAHGCC.Checked ||
				this.grpTestingPhases.Enabled == false))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void rdoSolidPhase_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoSolidPhase.Checked &&
				this.cmbLotNumber.SelectedIndex != -1 &&
				(this.rdoIS.Checked ||
				this.rdoIS37.Checked ||
				this.rdoISRT.Checked ||
				this.rdoAHGCC.Checked ||
				this.grpTestingPhases.Enabled == false))
			{
				this.btnOK.EnabledButton = true;
				this.btnOK.SetToolTip("");
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this._reagent.ReagentGuid = (Guid)this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.ReagentGuid];
			this._reagent.LotExpirationDate = (DateTime)this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.LotExpirationDate];
			this._reagent.ManufacturerName = this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
			this._reagent.LotNumber = this._dtReagents.Rows[this.cmbLotNumber.SelectedIndex][Common.VbecsTables.Reagent.LotNumber].ToString();

			if (this.grpTestingPhases.Enabled == true)
			{
				if (this.rdoIS.Checked == true)
					this._phase[0] = (int)Common.ReactivityPhase.IS;
				else if (this.rdoISRT.Checked == true)
					this._phase[0] = (int)Common.ReactivityPhase.ISandRT;
				else if (this.rdoIS37.Checked == true)
					this._phase[0] = (int)Common.ReactivityPhase.ISand37;
				else if (this.rdoAHGCC.Checked == true)
					this._phase[0] = (int)Common.ReactivityPhase.AHGandCC;
				else
					this._phase[0] = (int)Common.ReactivityPhase.Unknown;
			}

			if (this.rdoTube.Checked == true)
				this._testMethod = Common.TestingMethod.Tube;
			else if (this.rdoGel.Checked == true)
				this._testMethod = Common.TestingMethod.Gel;
			else if (this.rdoSolidPhase.Checked == true)
				this._testMethod = Common.TestingMethod.Solid;

			if (this._phase[0] == (int)Common.ReactivityPhase.ThreeSevenandAHG) //WeakD
			{
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
			else
			{
				DataTable dtReagentTestResults = BOL.RackTest.GetReagentTestResult(Common.LogonUser.LogonUserDivisionCode, _reagent.ReagentGuid, this._testingDateTime);
				int qcForPhase = dtReagentTestResults.Select("ReactivityPhaseCode = " + this._phase[0]).Length;
				if (dtReagentTestResults.Rows.Count > 0 && qcForPhase == 0)
				{
					DialogResult dlgRes = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC041.IncorrectPhase());
					if (dlgRes == DialogResult.Yes)
					{
						DlgPatientTestingComments dlg = new DlgPatientTestingComments(ref this._reagent);
						dlg.Message = "Justify the use of the new testing phase for the reagent";
						dlg.LoadComments();
                        dlg.ShowDialogFromLockedParent(this, false);
						if (dlg.DialogResult == DialogResult.Cancel)
						{
							this._reagent.CannedComment = null;
							this._reagent.Comments = "";
							return;
						}
						else
						{
							this._reagent.Comments = dlg.Comment;
							this.DialogResult = DialogResult.OK;
							this.Close();
						}
					}
					else
					{
						return;
					}
				}
				else
				{
					this.DialogResult = DialogResult.OK;
					this.Close();
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Checks if the reagent entered in the row has expired
		/// </summary>
		/// <param name="drLotNumber"></param>
		private bool CheckForExpiredAntisera(System.Data.DataRow drLotNumber)
		{
			DateTime LotExpirationDate;
			System.DateTime currentDate	= BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			DialogResult result = DialogResult.Yes;

			if(drLotNumber.IsNull("LotExpirationDate") == false)
			{
				LotExpirationDate = System.Convert.ToDateTime(drLotNumber["LotExpirationDate"]);
			}
			else
			{
				LotExpirationDate = DateTime.MaxValue;
			}

			if(LotExpirationDate >= currentDate)
			{
				if ( ((System.TimeSpan)(LotExpirationDate - currentDate)).Days < 1)
				{
					result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.AntiseraWillExpire(Common.VBECSDateTime.FormatDateTimeString(LotExpirationDate)));
					if (result != DialogResult.Yes)
					{
						return false;
					}
				}
			}
			else
			{

				//DlgExpiredAntisera dlg = new DlgExpiredAntisera("", (Guid)drLotNumber[Common.VbecsTables.Reagent.ReagentGuid], drLotNumber["ReagentTypeName"].ToString(), drLotNumber["LotNumber"].ToString(), (DateTime)drLotNumber["LotExpirationDate"]);
				DlgOverrideComment dlg = new DlgOverrideComment("Expired Antiserum",Common.StrRes.Tooltips.UC041.ExpiredAntiserum(drLotNumber["ReagentTypeName"].ToString()).ResString,"PT");
				dlg.ShowDialogFromLockedParent(this,false);
				if (dlg.DialogResult != DialogResult.OK)
				{
					return false;
				}
				else
				{
					_exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_antisera_used, dlg.Comment, Common.LogonUser.LogonUserName);
					_exRep.GenerateExceptionQC((Guid)drLotNumber[Common.VbecsTables.Reagent.ReagentGuid], Guid.Empty, Guid.Empty, _patientGuid, "", "", "", this._testingTech);
				}
			}

			return true;
		}

		/// <summary>
		/// Checks the inspection indicator on the reagent
		/// </summary>
		/// <param name="drLotNumber"></param>
		/// <returns></returns>
		private bool CheckForSatisfactoryReagent(DataRow drLotNumber)
		{
			DialogResult result;

			if ((bool)drLotNumber[Common.VbecsTables.Reagent.InspectionIndicator] == false)
			{
				result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.UnsatisfactoryReagent(drLotNumber["Manufacturer"].ToString(), drLotNumber["Lot_Number"].ToString(), drLotNumber["Expiration Date"].ToString()));
				return false;
			}
			return true;
		}

		private void DlgPatientAntigenTypingSpecificity_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (this.DialogResult != DialogResult.OK)
			{
				DialogResult questionResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.CancelTest());
				if (questionResult == DialogResult.No)
				{
					e.Cancel = true;
				}
				else
				{
					e.Cancel = false;
				}
			}
		}
	}
}

